#!/bin/bash

echo "================================================"
echo "Raspberry Pi AI HAT Installation + Verification"
echo "================================================"

# -----------------------------
# 1️⃣ System update
# -----------------------------
echo "🔄 Updating system..."
sudo apt update
sudo apt full-upgrade -y
sudo rpi-eeprom-update -a

# -----------------------------
# 2️⃣ Install AI HAT and camera packages
# -----------------------------
echo "📦 Installing AI HAT and camera packages..."

# Install dkms
sudo apt install -y dkms

# Check if hailo-h10-all is installed
if dpkg -s hailo-h10-all &> /dev/null; then
    echo "✅ hailo-h10-all is already installed. Skipping..."
else
    echo "⬇️ hailo-h10-all not found. Installing..."
    sudo apt install -y hailo-h10-all
fi

# Install rpicam packages
sudo apt install -y rpicam-apps
sudo apt install -y rpicam-apps-hailo-postprocess

# -----------------------------
# 3️⃣ Verification checks
# -----------------------------
echo ""
echo "🔍 Verification checks:"

# OS version
echo ""
echo "➡️ OS VERSION"
cat /etc/os-release

# Hailo device
echo ""
echo "➡️ HAILO DEVICE CHECK"
hailortcli fw-control identify || echo "❌ Hailo device not detected"

# Camera check (2 seconds preview)
echo ""
echo "➡️ CAMERA CHECK (2 seconds preview)"
rpicam-hello -t 2000 || echo "❌ Camera preview failed"

# Hailo post-process files
echo ""
echo "➡️ HAILO POST-PROCESS FILES"
ls /usr/share/rpi-camera-assets | grep hailo || echo "❌ No Hailo files found"

echo ""
echo "✅ Installation and verification complete!"
